﻿<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" codePage="1200" AutoEventWireup="false"%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
  <HEAD>
		<title>Zapisy na inne konto</title>
		<META http-equiv="Content-Type" content="text/html; charset=unicode">
		<script runat="server">
			public struct ZapisNaZleKonto {
				readonly public ZapisKsiegowy Zapis;
				readonly public ZapisKsiegowy ZapisZrodlowy;

				public ZapisNaZleKonto(ZapisKsiegowy zapis, ZapisKsiegowy zapisZrodlowy) {
					this.Zapis = zapis;
					this.ZapisZrodlowy = zapisZrodlowy;
				}
			}
				
    void Grid1_OnBeforeRow(object sender, Soneta.Web.RowEventArgs args) {
      ZapisNaZleKonto znzk = (ZapisNaZleKonto)args.Row;
			ZapisKsiegowy z = znzk.Zapis;
			ZapisKsiegowy zr = znzk.ZapisZrodlowy;
			colID1.EditValue = zr.ID;
			colID2.EditValue = z.ID;
			colNumer1.EditValue = zr.Numer;
			colNumer2.EditValue = z.Numer;
			colData1.EditValue = zr.Data;
			colData2.EditValue = z.Data;
			colNrDokumentu1.EditValue = zr.NumerDokumentu;
			colNrDokumentu2.EditValue = z.NumerDokumentu;
			colSymbol1.EditValue = zr.Konto != null ? zr.Konto.Symbol : "";
			colSymbol2.EditValue = z.Konto != null ? z.Konto.Symbol : "";
    }
			
		System.Collections.Generic.List<ZapisNaZleKonto> zapisy = new System.Collections.Generic.List<ZapisNaZleKonto>();	
    
    void DziennikWgZapisow_OnLoad(Object sender, EventArgs args){
			Soneta.Ksiega.ManagerKsiegowan.Rezultat r = null;
			Soneta.Ksiega.DekretBase dekret = null;
		
			if(DataContext1.Context.Contains(typeof(Soneta.Ksiega.ManagerKsiegowan.Rezultat)))
				r = (Soneta.Ksiega.ManagerKsiegowan.Rezultat)DataContext1.Get(typeof(Soneta.Ksiega.ManagerKsiegowan.Rezultat));
		
			if (DataContext1.Context.Contains(typeof(Soneta.Ksiega.DekretBase)))			
				dekret = (Soneta.Ksiega.DekretBase)DataContext1.Get(typeof(Soneta.Ksiega.DekretBase));

			System.Collections.Generic.List<DekretBase> dekrety = new System.Collections.Generic.List<DekretBase>();
			
			if (dekret != null)
				dekrety.Add(dekret);
			else if (r != null) {
				foreach (DekretBase d in r.Dekrety)
					dekrety.Add(d);
			}
			
			foreach (DekretBase d in dekrety) {
				foreach (ZapisKsiegowy z in d.Zapisy) {
					System.Collections.Generic.List<ZapisKsiegowy> zl =  new System.Collections.Generic.List<ZapisKsiegowy>(GetZapisRozliczajacy(z));
					if(zl!=null && zl.Count!=0)
						foreach(ZapisKsiegowy znzk in zl)
							zapisy.Add(new ZapisNaZleKonto(znzk,z));
				}
			}
			Grid1.DataSource = zapisy;
    }

		public System.Collections.Generic.IEnumerable<ZapisKsiegowy> GetZapisRozliczajacy(ZapisKsiegowy zapisZrodlowy) {
			if (zapisZrodlowy.ElementKsiegowalny == null)
				yield break;
			Soneta.Kasa.IRozliczalny rozliczalny = null;
			ZapisKsiegowy z = zapisZrodlowy;
			while (z.ElementKsiegowalny != null) {
				if (z.ElementKsiegowalny is Soneta.Kasa.IRozliczalny) {
					rozliczalny = (Soneta.Kasa.IRozliczalny)z.ElementKsiegowalny;
					break;
				} else if (z.ElementKsiegowalny is ZapisKsiegowy)
					z = (ZapisKsiegowy)z.ElementKsiegowalny;
				else
					break;
			}

			if (rozliczalny == null)
				yield break;

			foreach (RozliczenieSP roz in rozliczalny.Dokumenty) {
				IZapisKsiegowy zapis = ((IElementKsiegowalny)roz.Dokument).ZapisKsiegowy as ZapisKsiegowy;
				if (zapis == null)
					continue;
				zapis = zapis.OstatniZapis;
				if (((ZapisKsiegowy)zapis).Okres != zapisZrodlowy.Okres)
					continue;
				if (((ZapisKsiegowy)zapis).Konto == zapisZrodlowy.Konto)
					continue;
				yield return (ZapisKsiegowy)zapis;
			}
			foreach (RozliczenieSP roz in rozliczalny.Zaplaty) {
				IZapisKsiegowy zapis = ((IElementKsiegowalny)roz.Zaplata).ZapisKsiegowy as ZapisKsiegowy;
				if (zapis == null)
					continue;
				zapis = zapis.OstatniZapis;
				if (((ZapisKsiegowy)zapis).Okres != zapisZrodlowy.Okres)
					continue;
				if (((ZapisKsiegowy)zapis).Konto == zapisZrodlowy.Konto)
					continue;				
				yield return (ZapisKsiegowy)zapis;
			}
			yield break;
		}				
		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
  </HEAD>
	<body>
		<form id="DziennikWgZapisow" method="post" runat="server" onload="DziennikWgZapisow_OnLoad">
			<P><ea:datacontext id="DataContext1" runat="server"></ea:datacontext>
				<cc1:ReportHeader id="ReportHeader1" title="Zapisy na inne konto"
					runat="server"></cc1:ReportHeader><BR>
				<ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_OnBeforeRow" RowsInRow="2">
<Columns>
<ea:GridColumn Width="15" Align="Left" Caption="ID" ID="colID1" FontBold="True"></ea:GridColumn>
<ea:GridColumn Width="15" Align="Left" Caption="ID" ID="colID2"></ea:GridColumn>
<ea:GridColumn Width="20" Align="Left" Caption="Numer" ID="colNumer1" FontBold="True"></ea:GridColumn>
<ea:GridColumn Width="20" Align="Left" Caption="Numer" ID="colNumer2"></ea:GridColumn>
<ea:GridColumn Width="15" Align="Center" Caption="Data" ID="colData1" FontBold="True"></ea:GridColumn>
<ea:GridColumn Width="15" Align="Center" Caption="Data" ID="colData2"></ea:GridColumn>
<ea:GridColumn Width="25" Caption="Nr dokumentu" ID="colNrDokumentu1" FontBold="True"></ea:GridColumn>
<ea:GridColumn Width="25" Caption="Nr dokumentu" ID="colNrDokumentu2"></ea:GridColumn>
<ea:GridColumn Caption="Konto" ID="colSymbol1" FontBold="True"></ea:GridColumn>
<ea:GridColumn Caption="Konto" ID="colSymbol2"></ea:GridColumn>
</Columns>
				</ea:grid>
				<cc1:ReportFooter id="ReportFooter1" runat="server">
					<Subtitles>
						<cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
					</Subtitles>
				</cc1:ReportFooter></P>
		</form>
	</body>
</HTML>

